package com.hero.ui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.powers.CompoundPower;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CompoundPowerPanel extends AbilityPanel {

	private static final long serialVersionUID = 3259674678685251145L;

	CompoundPower parent;

	public CompoundPowerPanel(CompoundPower power) {
		super(false);
		parent = power;
		initWidgets();
		initListeners();
		layoutComponent();
	}

	/**
	 * Adds in a listener for updates to the purchase list.
	 * 
	 * @param listener
	 */
	public void addUpdateListener(GenericObjectList.UpdateListener listener) {
		selectionList.addUpdateListener(listener);
	}

	@Override
	protected GenericObjectList createSelectionList() {
		return new CompoundPowerList(parent);
	}

	@Override
	protected String getAvailableLabel() {
		return "Powers";
	}

	@Override
	protected ArrayList<GenericObject> getAvailableObjects() {
		ArrayList<GenericObject> ret = HeroDesigner.getActiveTemplate()
				.getPowers();
		if (GenericObject.findObjectByID(parent.getPowers(), "COMPOUNDPOWER") != null) {
			ret.remove(GenericObject.findObjectByID(parent.getPowers(),
					"COMPOUNDPOWER"));
		}
		return ret;
	}

	@Override
	protected ArrayList<GenericObject> getAvailablePrefabs() {
		return HeroDesigner.getInstance().getPrefabEquipment();
	}

	@Override
	protected ArrayList<GenericObject> getObjects() {
		return parent.getPowers();
	}

	/**
	 * Returns the selection/purchase list.
	 */
	@Override
	public GenericObjectList getSelectionList() {
		return selectionList;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		selectionList.setPasteAction(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				GenericObject obj = HeroDesigner.getCopyBuffer();
				if (obj instanceof Adder) {
					return;
				}
				obj.resetID();

				int insertionIndex = selectionList.getInsertionIndex();
				if (selectionList.insertBefore && (insertionIndex > 0)) {
					insertionIndex -= 1;
				}

				ArrayList<GenericObject> holder = new ArrayList<GenericObject>();
				if (obj instanceof com.hero.objects.List) {
					com.hero.objects.List list = (com.hero.objects.List) obj;
					holder = list.getObjects();
				} else if (obj instanceof CompoundPower) {
					CompoundPower cp = (CompoundPower) obj;
					holder = cp.getPowers();
				}
				obj.setIsEquipment(isEquipment());
				obj.setPower(isPower());
				for (GenericObject o : holder) {
					o = o.clone();
					o.resetID();
					o.setParent(null);
					o.setIsEquipment(isEquipment());
					o.setPower(isPower());
					o.setMainPower(parent);
					selectionList.addObject(o);
				}
				if (!((obj instanceof List) || (obj instanceof CompoundPower))) {
					obj.setMainPower(parent);
					selectionList.addObject(obj);
				}
				selectionList.checkIndices();
				HeroDesigner.getActiveHero().setDirty(true);
			}
		});
	}

	@Override
	protected boolean isEquipment() {
		return parent.isEquipment();
	}

	@Override
	protected boolean isPower() {
		return true;
	}

	@Override
	protected void layoutComponent() {
		add(selectionList, BorderLayout.CENTER);
		listMenu.setVisible(false);
	}

	/**
	 * Does nothing. This class is re-inited each time a CompoundPower is edited
	 * (no persistence).
	 */
	@Override
	public void reset() {
		// don't need to worry about this one....it's recreated each time a
		// CompoundPower is edited...
	}
}